/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *                                                                          *
 * FILE NAME:   IAI_EZMac_Lite.c                                            *
 *                                                                          *
 * DESIGNER:	Lukacs, Miklos; Kovacs, Krisztian                            *
 * PROGRAMMER: Lukacs, Miklos                                               *
 *                                                                          *
 * DESCRIPTION: EZMac functions                                             *
 *                                                                          *
 * REVISION:    01_5  Maj  10, 2005     From the original EZmac version     *
 *                                      removed:                            *
 *                                     - Multicast addressing.              *
 *                                     - Network address mode.              *
 *                                     - Reduced address mode.              *
 *                                     - Dynamic packet length.             *
 *                                     - Error detection.                   *
 *                                     - CID is mandatory.                  *
 *              01_6  Aug    11, 2005   Clearing the Timer IT flag in the   *
 *                                      Timer ISR                           *
 *				01_7  Dec	 08, 2005	Port to HiTech						*
 *				01_8  Sept	 28, 2006	Bug corrected: EZMacBuf_Read() 		*_
 *										function call during TX stops trans-*
 *										mission and cause CW signal			*			
 *                                                                          *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


//===============================================================================================
#pragma separate
char EZMac_Wake_Up(void)
{
   //state check
   // Changed by Laszlo Kadar on 26.11.05
   if (EZ_state!=EZMac_S_Sleep) return STATE_ERROR;

   //switch on EZRadio oscillator
   #ifdef SM_REAL_FUNCTION
    EZ_commands.arr[Power_command] |= 0x0008;
    EZRadio_Write(EZ_commands.arr[Power_command]);
   #endif

   //set EZMac state
   EZ_state = EZMac_S_WakeUp;
   EZInternalState = EZ_WakeUp;

   // setup timer1 to wake up after crystal is running
   _Set_Timer1(WAKING_UP_PERIOD);

   return MAC_OK;
}

//===============================================================================================
#pragma separate
char EZMac_Sleep(void)
{
   // state check
   // Changed by Laszlo Kadar on 26.11.05
   if (EZ_state!=EZMac_S_Idle) return STATE_ERROR;


   // switch off EZRadio
   #ifdef SM_REAL_FUNCTION
    EZ_commands.arr[Fifo_command] &=0xFFFD;                     //reset synchron latch
    EZRadio_Write(EZ_commands.arr[Fifo_command]);
//changed by mlu for rev1.4
    EZ_commands.arr[Power_command] &= 0xff05;                   //switch off wake-up timer
    EZ_commands.arr[Power_command] |= 0x0001;                   //to be sure that clk out is off
    EZRadio_Write(EZ_commands.arr[Power_command]);
   #endif

   //set EZMac state
   EZ_state = EZMac_S_Sleep;
   EZInternalState = EZ_Sleep;

   return MAC_OK;
}


//===============================================================================================
#pragma separate
char EZMac_Idle(void)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
   static _NEAR__ int8 BANK_2 dosleep;
   static _NEAR__ int8 BANK_2 retstate = MAC_OK;
#endif
#ifdef CCS_C_COMPILER
   int8 dosleep;
   int8 retstate = MAC_OK;
#endif

   //disable all interrupts
   _Turn_Off_Timer1();
   disable_interrupts(INT_EXT);

   if (EZ_state==EZMac_S_Idle) return MAC_OK;

   // sleep mode or unfinished wakeup
   if ((EZ_state==EZMac_S_WakeUp) || (EZ_state==EZMac_S_Sleep)) return WKUP_ERROR;

   // receiving or transmission is in process?
   //changed by krk on 02.22.2006; error: after	receiving the sleep state depend on the AXOT bit and not on AXOR!
   if ( (EZ_state == EZMac_S_Receiving) || (EZ_state == EZMac_S_TxPacket) )
         retstate = STATE_ERROR;

   // AXOT/AXOR test
   if ( (EZ_state == EZMac_S_Receiving) || (EZ_state == EZMac_S_PacketValid) )             // receiving states
   {
      dosleep = EZ_reg.bits.RCRB.AXOR;
      #ifdef SM_REAL_FUNCTION
       EZ_commands.arr[Fifo_command] &=0xFFFD;                       //reset synchron latch
       EZRadio_Write(EZ_commands.arr[Fifo_command]);
      #endif
   }
   else                                             // transmission or idle state ?
      dosleep = EZ_reg.bits.TCRB.AXOT;

   #ifdef SM_REAL_FUNCTION
    EZ_commands.arr[Fifo_command] &=0xFFFD;                          //reset synchron latch
    EZRadio_Write(EZ_commands.arr[Fifo_command]);
    EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP;  //switch off TX latch, and RX FIFO
    EZRadio_Write(EZ_commands.arr[Config_command]);
   #endif

   // go to sleep or idle state
   if (dosleep)
   {
      #ifdef SM_REAL_FUNCTION
       EZ_commands.arr[Power_command] &= 0xff07;
       EZRadio_Write(EZ_commands.arr[Power_command]);
      #endif
      EZ_state = EZMac_S_Sleep;
      EZInternalState = EZ_Sleep;
   }
   else
   {
      #ifdef SM_REAL_FUNCTION
       EZ_commands.arr[Power_command] &= 0xff0f;
       EZRadio_Write(EZ_commands.arr[Power_command]);
      #endif
      EZ_state = EZMac_S_Idle;
      EZInternalState = EZ_Idle;
   }
   #ifdef SM_REAL_FUNCTION
    EZRadio_Statusread ();                          //reset all non latched IT in Trixie
   #endif

   return retstate;
}


//===============================================================================================
#pragma separate
char EZMac_Transmit (void)
{
   // state check: state must be Idle or TransmitError
   if ((EZ_state==EZMac_S_Sleep) || (EZ_state==EZMac_S_WakeUp))
      return WKUP_ERROR;

   if ((EZ_state!=EZMac_S_Idle) && (EZ_state!=EZMac_S_TxError))
      return STATE_ERROR;

   #ifdef SM_TRIGGER_TX
   TRIGGER = 1;
   #endif

   //set up the registers
   //set the long of the packet

   /*changed by krk for rev1.3 -> if fixed packet length, the length of the transmitted packet is set
     by the PLENB register. It should be set by the higher layer before call the EZMac_Transmit() function*/
   //if( !EZ_reg.bits.MCRB.DNPL )
   //   EZ_reg.bytes.PLENB = EZ_reg.bytes.RPLMPL;

   //check the length of the packet: if it is incorrect, then back with error!
   if( (EZ_reg.bytes.PLENB > PLEN_MAX) || (EZ_reg.bytes.PLENB < 1) )
      return VALUE_ERROR;
   //if it isn't network address mode, then copy the self address to the correct register
   if( !EZ_reg.bits.MCRB.NWAD )
      EZ_reg.bytes.SIDB = EZ_reg.bytes.SFIDB;
   //set the preamble value: number of frequency + 3 (the first 2 copied automatically by Trixie)
   DataByteCounter = EZ_reg.bits.MCRB.NRF + 1;

   //Init the CRC calc. function
   Crc_Init();

   //set the frequency
   Frequency = EZ_reg.bits.TCRB.TF;
   #ifdef SM_REAL_FUNCTION
   EZ_commands.arr[Freq_command]=0xA000 + ((int16)(EZ_reg.bytes.FR[Frequency]-1)*FREQ_step+FREQ_start);
   EZRadio_Write(EZ_commands.arr[Freq_command]);
   #endif
   //next states will not read data bytes -> External Interrupt routine should set the SPI select pin
   SetSpiEn = TRUE;


   if( EZ_reg.bits.TCRB.LBTEN )
   {//listen before talk enable
      #ifdef SM_REAL_FUNCTION                    //configure Trixie for receiving
      EZRadio_Statusread ();
      EZ_commands.arr[Power_command] |= 0x0080;                   //switch on the receiver
      EZRadio_Write(EZ_commands.arr[Power_command]);
      #endif

      EZInternalState = EZ_TxCheckChannel;       //set the next state
      EZ_state = EZMac_S_TxCheckChannel;

      Data = 0;                                  //the parameters for LBT
      Data1 = 0;

      _Set_Timer1(FIRST_DQD_TIMER_LIMIT);        //set up T1 for DQD check
   }
   else
   {//listen before talk isn't enable
      #ifdef SM_REAL_FUNCTION                    //configure Trixie for transmit
                                                 //switch on TX reg.
      EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP | TXREG_USED;
      EZRadio_Write(EZ_commands.arr[Config_command]);
      EZRadio_Statusread ();
      EZ_commands.arr[Power_command] |= 0x0020;                   //switch on the transmitter
      EZRadio_Write(EZ_commands.arr[Power_command]);
      #endif
      #ifdef SM_TRIGGER_TX
      TRIGGER = 1;
      #endif

      EZ_state = EZMac_S_TxPacket;               //set the next state
      EZInternalState = EZ_TxSendPreamble;

      #ifdef SM_SOFTWDT_EN                       //set up the SW Watch dog timer for packet transmitting
      _Set_Timer1(MAX_TX_PACKET_TIMER);
      #endif

      clear_interrupt( INT_EXT );                //clear IT flag
      enable_interrupts( INT_EXT );              //enable ext IT
   }
   return MAC_OK;
}

//===============================================================================================
#pragma separate
char EZMac_Receive (void)
{
   // state check
   if ((EZ_state==EZMac_S_Sleep) || (EZ_state==EZMac_S_WakeUp))
      return WKUP_ERROR;

   if (EZ_state!=EZMac_S_Idle)
      return STATE_ERROR;

   //configure Trixie
   #ifdef SM_REAL_FUNCTION
    EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP | FIFO_USED;  //switch on RX FIFO
    EZRadio_Write(EZ_commands.arr[Config_command]);
    EZRadio_Statusread ();
    EZ_commands.arr[Power_command] |= 0x0080;                                    //switch on the receiver
    EZRadio_Write(EZ_commands.arr[Power_command]);
   #endif

   //set the frequency
   Frequency = EZ_reg.bits.RCRB.RF;

   //setup T1 to wake up the state machine (Ch_Check_Start in IAI_EZmac_internal.c will do)
   Ch_Check_Start(FALSE);
   //next states will not read data bytes -> Interrupt routine should set the SPI select pin
   SetSpiEn = TRUE;
   //parameters for channel check
   Data = 0;
   Data1 = 0;

   return MAC_OK;
}

//===============================================================================================
#pragma separate
char EZMacReg_Write(MacRegs Name, char Value)
{
   // register name check
   if (Name>EZ_LASTREG) return NAME_ERROR;

   // state check
   if ((EZ_state != EZMac_S_Idle) && (EZ_state != EZMac_S_Sleep) && (EZ_state != EZMac_S_WakeUp) )
      return STATE_ERROR;

   // check the parameters
   if ((Name==PLEN) || (Name == RPL)) if ((Value>PLEN_MAX) || (Value == 0)) return VALUE_ERROR;  // too long or 0 buffer
   if ((Name>=MSR) && (Name<=CID)) return VALUE_ERROR;      // read-only registers

   //is it necessary to modify any parameteres of Trixie?
   //set the output power of Trixie
   if (Name == TCR)
      {
      //set the new value of the output power
      EZ_commands.arr[TX_Ctrl_command] &= 0xFFF8;
      EZ_commands.arr[TX_Ctrl_command] |= (int16)((Value & 0x38) >> 3);
      //send the command to the Trixie
      EZRadio_Write(EZ_commands.arr[TX_Ctrl_command]);
      }
   //set the DRSSI limit
   if (Name == RCR)
      {
      //set the new value of the DRSSI limit
      EZ_commands.arr[RX_Ctrl_command] &= 0xFFF8;
      EZ_commands.arr[RX_Ctrl_command] |= (int16)((Value & 0x70) >> 4);
      //send the command to the Trixie
      EZRadio_Write(EZ_commands.arr[RX_Ctrl_command]);
      }

   // Updating register
   EZ_reg.arr[Name]=Value;

   return MAC_OK;
}

//===============================================================================================
#pragma separate
char EZMacReg_Read(MacRegs Name, char * Value)
{
   // register name check
   if (Name>EZ_LASTREG) return NAME_ERROR;

   if (Name==MSR)
      *Value = EZ_reg.bytes.MSRB & 0xFC; // low 2 bits are unnecessary
   else
      *Value = EZ_reg.arr[Name];

   return MAC_OK;
}

//===============================================================================================
#pragma separate
char EZMacBuf_Write(char * buf)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
   static _NEAR__ int BANK_2 i;
   static _NEAR__ int BANK_2 buflen;
#endif
#ifdef CCS_C_COMPILER
   int i;
   int buflen;
#endif

   // state check
   if ((EZ_state != EZMac_S_Idle) && (EZ_state != EZMac_S_Sleep) && (EZ_state != EZMac_S_WakeUp) )
      return STATE_ERROR;

   buflen = (EZ_reg.bytes.PLENB<PLEN_MAX) ? EZ_reg.bytes.PLENB : PLEN_MAX;

   for (i=0; i < buflen; i++)
   {
      EZ_dbuff[i] = buf[i];
   }

   return MAC_OK;

}

//===============================================================================================
#pragma separate
char EZMacBuf_Read(char * buf)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
   static _NEAR__ int BANK_2 i;
#endif
#ifdef CCS_C_COMPILER
   int i;
#endif

   // state check
   if ( ( EZ_state != EZMac_S_Idle ) && ( EZ_state != EZMac_S_PacketValid ) )
      return STATE_ERROR;

   //the length of the packet will be copied all cases after receiving to the PLEN register
   for (i=0; i < EZ_reg.bytes.PLENB; i++)
   {
      buf[i] = EZ_dbuff[i];
   }

   //go to Idle or Sleep state (depend on AXOR bit)
   if (EZ_state==EZMac_S_PacketValid) EZMac_Idle();

   //disable all interrupts
   _Turn_Off_Timer1();
   disable_interrupts(INT_EXT);

   return MAC_OK;
}

//===============================================================================================
#pragma separate
/*only for advanced users!*/
// Changed by Laszlo Kadar on 26.11.05
#ifdef HITECH_COMPILER
 #pragma interrupt_level 1
#endif
char EZRadio_Write (int16 EZcommand)
{
   //send a command for Trixie
   SEL_PIN = 0;                     //SPI sel pin = 0
   EZ_Spi_Write(EZcommand>>8);      //write high byte
   EZ_Spi_Write(EZcommand);         //write low byte
   SEL_PIN = 1;                     //set SPI sel pin
}

//===============================================================================================
#pragma separate
/*only for advanced users!*/
char EZRadio_Statusread (void)
{

   if ((EZ_state!=EZMac_S_Sleep) && (EZ_state!=EZMac_S_Idle))
      return STATE_ERROR;

   //read and copy the STATUS word of the Trixie to the STRH and STRL registers
   SEL_PIN = 0;
   STRH=Spi_Comm0();
   STRL=Spi_Comm0();
   SEL_PIN = 1;

   return MAC_OK;
}

//===============================================================================================
#pragma separate
void EZMac_SysInit (void)
{
   //set port directions
   MOSI_DIR=0;
   CLK_DIR=0;
   SEL_DIR=0;
   IRQ_DIR=1;
   SEL_PIN = 1;

   //set external IT
   ext_int_edge(H_TO_L);                                         // ext. interrupt for falling edge
   clear_interrupt( INT_EXT );
   enable_interrupts( INT_EXT );

   //enable global IT
   enable_interrupts( GLOBAL );

}

//===============================================================================================
#pragma separate
void EZMac_Config (void)
{

   //reset the EZMac registers
   EZ_Reg_Default();

   //set the default register values of the Trixie
   #ifdef SM_REAL_FUNCTION
//changed by mlu for rev1.4
   EZ_Radio_Config();
   
   /*changed by krk for rev1.51 -> ARSSI measurement*/
   #ifdef ARSSI_USED
    setup_adc(ADC_OFF);
    setup_adc_ports(ARSSI_PIN);
    set_adc_channel(ARSSI_CHANNEL);
   #endif
   
/*   Config_command=0x8000 | FREQ_Band | XTAL_COMP;
   Power_command=0x8201;            //switch everything off, also the clk output
   Fifo_command=0xCA81;             //Fill:synchron pattern; IT level:8; disable sensitive reset
   Data_Rate_command=0xC626;        //9600bps
   RX_Ctrl_command=RX_cmd_init_value;          // BW:135kHz; VDI:always on; LNA:max; DRSSI:-103; Pin8: VDIout
   TX_Ctrl_command=TX_cmd_init_value;          //f0+df; df:75kHz; Pout:min
   Data_Filter_command=0xC22F;      //CR:slow; Digital LPF; DQD:7
   AFC_command=0xC4E7;              //enabled; fine mode; auto,keep offset; +7/-8; output enabled
   Freq_command=0xA000 + ((int16)(FREQ_maxid/2)*FREQ_step + FREQ_start);

   EZRadio_Write(Power_command);
   EZRadio_Write(Config_command);
   EZRadio_Write(Fifo_command);
   EZRadio_Write(Data_Rate_command);
   EZRadio_Write(TX_Ctrl_command);
   EZRadio_Write(RX_Ctrl_command);
   EZRadio_Write(Data_Filter_command);
   EZRadio_Write(AFC_command);
   EZRadio_Write(Freq_command);
   Power_command |= 0x0010;                                    //switch on the synthesizer for calibrating
   EZRadio_Write(Power_command);
   Power_command &= 0xff07;
   EZRadio_Write(Power_command);

   EZRadio_Statusread ();*/
   #endif

}
//===============================================================================================

void EZMac_CommISR (void)
{
#ifdef HITECH_COMPILER
   static _NEAR__ volatile reg_union BANK_2 spare;
#endif
#ifdef CCS_C_COMPILER
   volatile reg_union spare;
#endif

#ifdef FIX_MEM_ADDRESS
 #pragma byte spare = 0x2A
#endif

   SEL_PIN = 1;
   SEL_PIN = 0;                                             //SEL=0
   STRH = Spi_Comm0();                                      //read status to decide which event caused the IT
   STRL = Spi_Comm0();
   spare.adat = STRH;
   if( SetSpiEn )
      SEL_PIN = 1;                                          //in receiver state the state machine will read next 8 bit, don't have to set the SEL pin

   //   spare.testreg&=0x80;
   if (spare.testreg.bit7)                                  //RGIT or FFIT
   {
      #ifdef SM_REAL_FUNCTION
       if (spare.testreg.bit5)
         State_Machine (IT_SOURCE_COMM_OVUR);               //RGIT or FFIT and overrun or underrun
       else
         State_Machine (IT_SOURCE_COMM);                    //pure RGIT or FFIT
       #ifdef SM_DEBUG
        LED4 = 0;                                           //trigger output to measure the State Machine timing
       #endif
      #endif

     #ifndef SM_REAL_FUNCTION
      if (TxOrRx==TRANSMIT) TX_ready=TRUE;
      else
      {
         SpiPuf[in_spi] = Spi_Comm(0);                      // Store new character
         in_spi++;
         if (in_spi == SpiPufLen) in_spi = 0;               // buffer is circular
         if (in_spi == out_spi)                             // is the buffer full?
         {
            out_spi++;                                      // if yes, inc output pointer
            if (out_spi == SpiPufLen) out_spi = 0;
         }
         else Nr_spi++;                                     // if not, inc Nr of characters

      }
     #endif
   }
   #ifdef SM_REAL_FUNCTION
    if (spare.testreg.bit5) State_Machine (IT_SOURCE_OVUR); // FIFO overrun or TX reg. underrun
    #ifdef SM_DEBUG
     LED4 = 0;                                              //trigger output to measure the State Machine timing
    #endif
   #endif

   if (spare.testreg.bit6)                                  // Power on reset
   {
   }
   if (spare.testreg.bit4)                                                   // Wake up timer
   {
   }
   if (spare.testreg.bit3)                                                   // External IT
   {
   }
   if (spare.testreg.bit2)                                                   // Low Battery detector
   {
   }
}

//===============================================================================================
void EZMac_TimerISR (void)
{
   #ifdef SM_DEBUG
    TRIGGER2 = 0;
   #endif
   //turn off timer and IT
   setup_timer_1( T1_DISABLED );
   disable_interrupts(INT_TIMER1);
   /*changed by krk for rev1.6 -> clear the flag*/
   clear_interrupt(INT_TIMER1);
   //call the state machine
   State_Machine (IT_SOURCE_T1);
   #ifdef SM_DEBUG
    LED4 = 0;
   #endif
}



